#!/bin/bash

while true
do
	avr-gcc main.cpp -mmcu=atmega328p -Wall -Wno-sign-compare -Os -ffunction-sections -fdata-sections -Wl,--gc-sections -std=c++11 -o main.elf
	objcopy main.elf -O ihex main.hex
	avrdude -P /dev/ttyACM0 -c usbasp -p m328p -U flash:w:main.hex:i
	avr-size main.elf -dC --mcu atmega328p
	
	rm main.elf -f
	rm main.hex -f
	
	read
	clear
done

exit 0
